/* Foundation Systems Developer Technical Support Sample Code
 * ----------------------------------------------------------
 * NewtonID Constants - NewtonID Developer Kit
 * by Adam Tow, Foundation Systems
 * Last Update: January 1, 1998
 * Copyright  1997-1998 Foundation Systems. All rights reserved.
 *
 * You may incorporate this sample code into your applications without
 * restriction. This sample code has been provided "AS IS" and the
 * responsibility for its operation is 100% yours. If you modify and
 * redistribute this source, we require that you make it clear in the source
 * that is was derived from Foundation Systems provided sample code, but
 * that you have made changes.
 *
 * Avi Drissman made changes.
 */


constant kNewtonIDAppSymbol := '|NewtonID:NewtonID|;
constant kRegistrationType := 1;
constant kAcceptMsg := "Registration code accepted! Thank you for registering.";
constant kRejectMsg := "This registration code is invalid. Please try entering it again.\n\nIf you cannot get it to work, please email drissman@acm.org for help.";
constant kRequireNewtonIDMessage := "To register, you have to install NewtonID. For example:\n\n" &
								    			"NewtonID Owner Name: John Doe\nSN: 0000 0000 A9F5 C564\n\nhttp://www.tow.com/";

DefConst('kGetNewtonIDFunc, func() begin
   local newtonID := GetAppPrefs(kNewtonIDAppSymbol, {});
   
   if newtonID.name then begin
      local serialnumber;
         
      try serialnumber := call ROM_GetSerialNumber with ()
      onexception |evt.ex| do serialnumber := nil;
         
      if serialnumber then serialnumber := StrHexDump(serialnumber, 2);
        
      return { name: newtonID.name, serialnumber: serialnumber };
   end;
   else return nil;
end);


DefConst('kMyPasswordFunc, func(name, serialnumber, regcode, regtype) begin
	local result;
	
	if regtype = 1 and ClassOf(regcode) = 'int then begin

		// Level 1NewtonID Owner Name.
		// Continue with your verification code, returning
		// true if the regcode is valid.
		
		result := call MinLockCheck.CheckCode with (name, regcode);
		if result then return true;
		
		local cleanName := Upcase(clone(name));
		cleanName := StringFilter(cleanName, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", 'passAll);
		return call MinLockCheck.CheckCode with (cleanName, regcode);
	
	end;
	else if regtype = 2 then begin
	
		// Level 2Hardware Serial Number.
		// Continue with your verification code, returning
		// true if the regcode is valid.
		
	end;
	else if regtype = 3 then begin
	
		// Level 3NewtonID Owner Name and HW Serial Number.
		// Continue with your verification code, returning
		// true if the regcode is valid.
		
	end;
	return nil;
end);


DefConst('kMyVerificationFunc , func(code, registering) begin
	local NewtonID := call kGetNewtonIDFunc with ();
	local NewtonIDSoupEntry := GetAppPrefs(kNewtonIDAppSymbol, {});
	local regCode, serialnumber;

	if NewtonID then begin
		if registering then regCode := code;
		else regCode := NewtonIDSoupEntry.(kAppSymbol);
		
		if not regCode then
			return 'unregistered;

		if call kMyPasswordFunc with (NewtonID.name,
			NewtonID.serialnumber, regcode,
			kRegistrationType) then begin
				if registering then begin
					NewtonIDSoupEntry.(kAppSymbol) := regcode;
					EntryFlushXmit(NewtonIDSoupEntry, nil);
					GetRoot():Notify(kNotifyAlert, kAppName, 
						kAcceptMsg);
				end;
				return 'registered;
		end;
		else begin
			if registering then
				GetRoot():Notify(kNotifyAlert, kAppName, kRejectMsg);
			return nil;
		end;
	end;
	else return 'noNewtonID;
end);
